
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ferry_profit")

# Create variables
vehicle_tickets = m.addVar(vtype=GRB.INTEGER, name="vehicle_tickets")
passenger_tickets = m.addVar(vtype=GRB.INTEGER, name="passenger_tickets")

# Set objective function
m.setObjective(50 * vehicle_tickets + 50 * passenger_tickets, GRB.MAXIMIZE)

# Add constraints
m.addConstr(vehicle_tickets + passenger_tickets <= 100, "total_tickets")
m.addConstr(vehicle_tickets >= 10, "min_vehicle_tickets")
m.addConstr(passenger_tickets >= 5 * vehicle_tickets, "passenger_vehicle_ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of vehicle tickets: {vehicle_tickets.x}")
    print(f"Number of passenger tickets: {passenger_tickets.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

