
from gurobipy import *

# Create a new model
m = Model("Ferry_Ticket_Sales")

# Define variables
x1 = m.addVar(name="vehicle_tickets", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="passenger_tickets", vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(50*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, name="total_tickets")
m.addConstr(x1 >= 10, name="min_vehicle_tickets")
m.addConstr(x2 >= 5*x1, name="passenger_to_vehicle_ratio")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {int(x1.x)} tickets, {x2.varName} = {int(x2.x)} tickets")
else:
    print("No optimal solution found")

