
import gurobi

def solve_ferry_ticket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="vehicle_tickets", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="passenger_tickets", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 50x1 + 50x2
    model.setObjective(50*x1 + 50*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name="total_tickets")
    model.addConstr(x1 >= 10, name="min_vehicle_tickets")
    model.addConstr(x2 >= 5*x1, name="passenger_to_vehicle_ratio")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Vehicle tickets = {x1.varValue}, Passenger tickets = {x2.varValue}")
    else:
        print("The model is infeasible")

solve_ferry_ticket_problem()
