
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("fish_transport")

# Create variables
freight_trains = m.addVar(vtype=GRB.INTEGER, name="freight_trains")
cargo_ships = m.addVar(vtype=GRB.INTEGER, name="cargo_ships")


# Set objective function
m.setObjective(2000 * freight_trains + 7000 * cargo_ships, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100 * freight_trains + 180 * cargo_ships <= 1500, "budget")
m.addConstr(freight_trains < cargo_ships, "trip_limit")
m.addConstr(freight_trains >=0, "non_negativity_freight")
m.addConstr(cargo_ships >= 0, "non_negativity_cargo")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal}")
    print(f"Number of freight train trips: {freight_trains.x}")
    print(f"Number of cargo ship trips: {cargo_ships.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

