
from gurobipy import *

# Create a new model
m = Model("Fish_Transport")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="freight_train_trips")
x2 = m.addVar(vtype=GRB.INTEGER, name="cargo_ship_trips")

# Set the objective function
m.setObjective(2000*x1 + 7000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100*x1 + 180*x2 <= 1500, "budget")
m.addConstr(x1 <= x2 - 1, "trip_constraint") # Adjusted to ensure x1 < x2 by making it x1 <= x2 - 1 for integer solutions

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Freight Train Trips: {x1.x}")
    print(f"Cargo Ship Trips: {x2.x}")
    print(f"Total Fish Transported: {2000*x1.x + 7000*x2.x}")
else:
    print("No optimal solution found")
