
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="x1", lb=0, vtype=gurobi.GRB.INTEGER)  # Freight train trips
x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.INTEGER)  # Cargo ship trips

# Objective function: Maximize 2000x1 + 7000x2
model.setObjective(2000*x1 + 7000*x2, gurobi.GRB.MAXIMIZE)

# Budget constraint: 100x1 + 180x2 <= 1500
model.addConstr(100*x1 + 180*x2 <= 1500, name="budget_constraint")

# Trip constraint: x1 < x2
model.addConstr(x1 <= x2 - 1, name="trip_constraint")  # Adjusted for integer solution

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Freight train trips: {x1.varValue}")
    print(f"Cargo ship trips: {x2.varValue}")
    print(f"Total fish transported: {2000*x1.varValue + 7000*x2.varValue}")
else:
    print("No optimal solution found.")
