
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("YoungBucksProduction")

# Create variables
alpha_hours = m.addVar(lb=0, name="alpha_hours")  # Hours running plant Alpha
beta_hours = m.addVar(lb=0, name="beta_hours")  # Hours running plant Beta


# Set objective function: Minimize total cost
m.setObjective(40 * alpha_hours + 100 * beta_hours, GRB.MINIMIZE)

# Add constraints:
# Cement production constraint
m.addConstr(3 * alpha_hours + 5 * beta_hours >= 100, "cement_production")

# Stucco production constraint
m.addConstr(2 * alpha_hours + 4 * beta_hours >= 80, "stucco_production")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Minimum cost: ${m.objVal}")
    print(f"Hours running plant Alpha: {alpha_hours.x}")
    print(f"Hours running plant Beta: {beta_hours.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

