
from gurobipy import *

# Create a new model
m = Model("Young_Bucks_Production")

# Define variables
x1 = m.addVar(name='hours_Plant_Alpha', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='hours_Plant_Beta', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(40*x1 + 100*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 >= 100, name='cement_demand')
m.addConstr(2*x1 + 4*x2 >= 80, name='stucco_demand')

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Run Plant Alpha for {x1.x} hours and Plant Beta for {x2.x} hours.")
else:
    print("No optimal solution found.")
