
import gurobi

def solve_production_planning_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="Alpha_hours", lb=0)  # hours of running plant Alpha
    x2 = model.addVar(name="Beta_hours", lb=0)   # hours of running plant Beta

    # Objective function: minimize 40*x1 + 100*x2
    model.setObjective(40 * x1 + 100 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x1 + 5 * x2 >= 100, name="cement_demand")  # cement demand
    model.addConstr(2 * x1 + 4 * x2 >= 80, name="stucco_demand")  # stucco demand

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours of running plant Alpha: {x1.varValue}")
        print(f"Hours of running plant Beta: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_production_planning_problem()
