
import gurobipy as gp

# Create a new model
m = gp.Model("X-Luxury_Cloth")

# Create variables
coats = m.addVar(vtype=gp.GRB.CONTINUOUS, name="coats")
skirts = m.addVar(vtype=gp.GRB.CONTINUOUS, name="skirts")

# Set objective function
m.setObjective(12 * coats + 16 * skirts, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5 * coats + 3 * skirts <= 45, "designing_time")
m.addConstr(2.5 * coats + 3.5 * skirts <= 70, "printing_time")
m.addConstr(coats >= 0, "coats_nonnegative")  # Explicit non-negativity constraints
m.addConstr(skirts >= 0, "skirts_nonnegative")

# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Coats: {coats.x}")
    print(f"Number of Skirts: {skirts.x}")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

