
from gurobipy import *

# Create a new model
m = Model("X-Luxury_Cloth")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="coats", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="skirts", lb=0)

# Set the objective function
m.setObjective(12*x1 + 16*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 3*x2 <= 45, "designing_time")
m.addConstr(2.5*x1 + 3.5*x2 <= 70, "printing_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of coats: {x1.x}")
    print(f"Number of skirts: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
