
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="coats")
    x2 = model.addVar(lb=0, name="skirts")

    # Set the objective function
    model.setObjective(12 * x1 + 16 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1.5 * x1 + 3 * x2 <= 45, name="designing_time_constraint")
    model.addConstr(2.5 * x1 + 3.5 * x2 <= 70, name="printing_time_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of coats: {x1.varValue}")
        print(f"Number of skirts: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
