
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("cheese_mix")

# Create variables
pizza_mix = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pizza_mix")
mac_cheese_mix = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mac_cheese_mix")

# Set objective function
model.setObjective(3 * pizza_mix + 3.25 * mac_cheese_mix, GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * pizza_mix + 1 * mac_cheese_mix >= 30, "mozzarella")
model.addConstr(2 * pizza_mix + 5 * mac_cheese_mix >= 25, "cheddar")
model.addConstr(1 * pizza_mix + 2 * mac_cheese_mix >= 5, "salt")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Pizza mix: {pizza_mix.x:.2f}")
    print(f"Mac and cheese mix: {mac_cheese_mix.x:.2f}")

