
from gurobipy import *

# Create a new model
m = Model("Cheese_Mix_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="pizza_mixes")
x2 = m.addVar(lb=0, name="mac_and_cheese_mixes")

# Set the objective function
m.setObjective(3*x1 + 3.25*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + x2 >= 30, "mozzarella_requirement")
m.addConstr(2*x1 + 5*x2 >= 25, "cheddar_requirement")
m.addConstr(x1 + 2*x2 >= 5, "salt_requirement")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of pizza mixes: {x1.x}")
    print(f"Number of mac and cheese mixes: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
