
import gurobi

def solve_cheese_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Pizza_mix", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="Mac_and_cheese_mix", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(3*x1 + 3.25*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4*x1 + x2 >= 30, name="Mozzarella_Constraint")
    model.addConstr(2*x1 + 5*x2 >= 25, name="Cheddar_Constraint")
    model.addConstr(x1 + 2*x2 >= 5, name="Salt_Constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Pizza mix: {x1.varValue}")
        print(f"Mac and cheese mix: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_cheese_mix_problem()
