
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("hockey_store")

# Create variables
hockey_sticks = m.addVar(lb=0, vtype=GRB.INTEGER, name="hockey_sticks")
pucks = m.addVar(lb=0, vtype=GRB.INTEGER, name="pucks")

# Set objective function
m.setObjective(50 * hockey_sticks + 5 * pucks, GRB.MAXIMIZE)

# Add constraints
m.addConstr(75 * hockey_sticks + 2 * pucks <= 20000, "budget")
m.addConstr(hockey_sticks >= 50, "min_sticks")
m.addConstr(hockey_sticks <= 110, "max_sticks")
m.addConstr(pucks <= 3 * hockey_sticks, "puck_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of hockey sticks to sell: {hockey_sticks.x}")
    print(f"Number of pucks to sell: {pucks.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

