
from gurobipy import *

# Create a new model
m = Model("Hockey_Sticks_and_Pucks")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hockey_sticks")
x2 = m.addVar(vtype=GRB.INTEGER, name="pucks")

# Set the objective function
m.setObjective(50*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(75*x1 + 2*x2 <= 20000, "budget")
m.addConstr(x1 >= 50, "min_hockey_sticks")
m.addConstr(x1 <= 110, "max_hockey_sticks")
m.addConstr(x2 <= 3*x1, "pucks_vs_sticks")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hockey sticks to sell: {x1.x}")
    print(f"Pucks to sell: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
