
import gurobipy as gp

# Create a new model
model = gp.Model("Hockey_Sticks_and_Pucks")

# Define variables
x1 = model.addVar(lb=50, ub=110, name="hockey_sticks")  # At least 50, at most 110 hockey sticks
x2 = model.addVar(lb=0, name="pucks")  # Non-negative number of pucks

# Objective function: Maximize profit
model.setObjective(50*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(75*x1 + 2*x2 <= 20000, name="budget_constraint")  # Budget constraint
model.addConstr(x2 <= 3*x1, name="pucks_to_sticks_ratio")  # Pucks to sticks ratio

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of hockey sticks: {x1.varValue}")
    print(f"Optimal number of pucks: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("The model is infeasible.")
