
import gurobipy as gp

# Create a new model
model = gp.Model("poster_optimization")

# Create variables
northside = model.addVar(vtype=gp.GRB.INTEGER, name="northside")
southside = model.addVar(vtype=gp.GRB.INTEGER, name="southside")
central = model.addVar(vtype=gp.GRB.INTEGER, name="central")

# Set objective function
model.setObjective(20000 * northside + 50000 * southside + 40000 * central, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(500 * northside + 1000 * southside + 800 * central <= 30000, "budget")
model.addConstr(southside <= 5, "southside_limit")
model.addConstr(central <= (northside + southside + central) / 3, "central_limit")
model.addConstr(northside >= 0.2 * (northside + southside + central), "northside_limit")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Viewership: {model.objVal}")
    print(f"Northside Posters: {northside.x}")
    print(f"Southside Posters: {southside.x}")
    print(f"Central Posters: {central.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

