
from gurobipy import *

# Create a model
m = Model("Poster_Placement")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="northside_mall")
x2 = m.addVar(vtype=GRB.INTEGER, name="southside_mall")
x3 = m.addVar(vtype=GRB.INTEGER, name="central_mall")

# Objective function: Maximize viewership
m.setObjective(20000*x1 + 50000*x2 + 40000*x3, GRB.MAXIMIZE)

# Constraints
m.addConstr(x2 <= 5, "southside_limit")
m.addConstr(x3 <= (1/3)*(x1 + x2 + x3), "central_mall_limit")
m.addConstr(x1 >= 0.2*(x1 + x2 + x3), "northside_minimum")
m.addConstr(500*x1 + 1000*x2 + 800*x3 <= 30000, "budget_constraint")

# Optimize the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective Value: {m.objVal}")
