
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("poster_placement")

# Define variables
x1 = model.addVar(name="northside", vtype=GRB.INTEGER)  # posters at northside mall
x2 = model.addVar(name="southside", vtype=GRB.INTEGER)  # posters at southside mall
x3 = model.addVar(name="central", vtype=GRB.INTEGER)   # posters at central mall

# Objective function: Maximize viewership
model.setObjective(20000*x1 + 50000*x2 + 40000*x3, GRB.MAXIMIZE)

# Budget constraint
model.addConstr(500*x1 + 1000*x2 + 800*x3 <= 30000, name="budget_constraint")

# Southside mall limit
model.addConstr(x2 <= 5, name="southside_limit")

# Central mall limitation
model.addConstr(2*x3 <= x1 + x2, name="central_limitation")

# Northside mall requirement
model.addConstr(4*x1 >= x2 + x3, name="northside_requirement")

# Non-negativity constraints
model.addConstr(x1 >= 0, name="x1_nonneg")
model.addConstr(x2 >= 0, name="x2_nonneg")
model.addConstr(x3 >= 0, name="x3_nonneg")

# Solve the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Northside Mall: {x1.varValue}")
    print(f"Southside Mall: {x2.varValue}")
    print(f"Central Mall: {x3.varValue}")
    print(f"Max Viewership: {model.objVal}")
else:
    print("No optimal solution found.")
