
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("winter_sports")

# Create variables
skis = m.addVar(vtype=GRB.INTEGER, name="skis")
snowboards = m.addVar(vtype=GRB.INTEGER, name="snowboards")

# Set objective function
m.setObjective(200 * skis + 175 * snowboards, GRB.MAXIMIZE)

# Add constraints
m.addConstr(500 * skis + 400 * snowboards <= 20000, "budget")
m.addConstr(skis >= 10, "min_skis")
m.addConstr(skis <= 30, "max_skis")
m.addConstr(snowboards <= 0.5 * skis, "snowboard_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Number of skis:', skis.x)
    print('Number of snowboards:', snowboards.x)
elif m.status == GRB.INF_OR_UNBD or m.status == GRB.INFEASIBLE:
    print('Problem is infeasible or unbounded')
else:
    print('Optimization ended with status:', m.status)

