
from gurobipy import *

# Create a new model
m = Model("Winter_Sports_Store")

# Define variables
x1 = m.addVar(name='x1', lb=10, ub=30, vtype=GRB.INTEGER)
x2 = m.addVar(name='x2', lb=0, vtype=GRB.INTEGER)

# Set the objective function
m.setObjective(200*x1 + 175*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(500*x1 + 400*x2 <= 20000, name='budget_constraint')
m.addConstr(x2 <= 0.5*x1, name='snowboard_limit')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of pairs of skis: {x1.x}")
    print(f"Number of snowboards: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
