
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(lb=10, ub=30, name="pairs_of_skis")  # At least 10, at most 30 pairs of skis
x2 = m.addVar(lb=0, name="snowboards")  # Non-negative number of snowboards

# Objective function: Maximize profit
m.setObjective(200 * x1 + 175 * x2, gp.GRB.MAXIMIZE)

# Budget constraint
m.addConstr(500 * x1 + 400 * x2 <= 20000, name="budget_constraint")

# Snowboards sales constraint
m.addConstr(x2 <= 0.5 * x1, name="snowboards_sales_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of pairs of skis to buy and sell: {x1.varValue}")
    print(f"Number of snowboards to buy and sell: {x2.varValue}")
    print(f"Maximal profit: {m.objVal}")
else:
    print("No optimal solution found.")
