
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("woodworking")

# Create variables
cutting_boards = m.addVar(vtype=GRB.INTEGER, name="cutting_boards")
chairs = m.addVar(vtype=GRB.INTEGER, name="chairs")

# Set objective function
m.setObjective(14 * cutting_boards + 25 * chairs, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * cutting_boards + 70 * chairs <= 1500, "time_constraint")
m.addConstr(cutting_boards + chairs <= 40, "wood_constraint")
m.addConstr(cutting_boards >= 0, "cutting_boards_nonnegative")  # Explicit non-negativity constraints
m.addConstr(chairs >= 0, "chairs_nonnegative")  # Explicit non-negativity constraints


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal Solution:")
    print(f"Number of cutting boards: {cutting_boards.x}")
    print(f"Number of chairs: {chairs.x}")
    print(f"Maximum profit: ${m.objVal}")

