
from gurobipy import *

# Create a model
m = Model("Wood_Artist_Problem")

# Define variables
x1 = m.addVar(name='cutting_boards', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='chairs', vtype=GRB.INTEGER, lb=0)

# Set objective function
m.setObjective(14*x1 + 25*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 70*x2 <= 1500, name='time_constraint')
m.addConstr(x1 + x2 <= 40, name='total_items_constraint')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
