
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='cutting_boards', lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='chairs', lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 14*x1 + 25*x2
    model.setObjective(14*x1 + 25*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(30*x1 + 70*x2 <= 1500, name='time_constraint')
    model.addConstr(x1 + x2 <= 40, name='material_constraint')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Maximum profit: ${14*x1.x + 25*x2.x:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
