
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_mix")

# Create variables
orange_juice = m.addVar(nonneg=True, name="orange_juice")  # x1
apple_juice = m.addVar(nonneg=True, name="apple_juice")  # x2

# Set objective function
m.setObjective(3 * orange_juice + 9 * apple_juice, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * orange_juice + 10 * apple_juice >= 100, "vitamin_A")
m.addConstr(5 * orange_juice + 3 * apple_juice >= 200, "vitamin_D")
m.addConstr(12 * orange_juice + 15 * apple_juice <= 150, "vitamin_E")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal amount of Vitamin K: {m.objVal}")
    print(f"Cups of orange juice: {orange_juice.x}")
    print(f"Cups of apple juice: {apple_juice.x}")

