
from gurobipy import *

# Create a new model
m = Model("Vitamin_Mix")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="orange_juice")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="apple_juice")

# Set the objective function
m.setObjective(3*x1 + 9*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 10*x2 >= 100, "Vitamin_A")
m.addConstr(5*x1 + 3*x2 >= 200, "Vitamin_D")
m.addConstr(12*x1 + 15*x2 <= 150, "Vitamin_E")
m.addConstr(x1 >= 0, "Non_Negativity_Orange")
m.addConstr(x2 >= 0, "Non_Negativity_Apple")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Orange Juice: {x1.x}")
    print(f"Apple Juice: {x2.x}")
    print(f"Objective Function Value (Vitamin K): {m.objVal}")
else:
    print("No optimal solution found.")
