
import gurobi

def solve_vitamin_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="orange_juice", lb=0)
    x2 = model.addVar(name="apple_juice", lb=0)

    # Define the objective function
    model.setObjective(3*x1 + 9*x2, gurobi.MINIMIZE)

    # Define the constraints
    model.addConstr(6*x1 + 10*x2 >= 100, name="vitamin_A")
    model.addConstr(5*x1 + 3*x2 >= 200, name="vitamin_D")
    model.addConstr(12*x1 + 15*x2 <= 150, name="vitamin_E")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cups of orange juice: {x1.varValue}")
        print(f"Cups of apple juice: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_vitamin_mix_problem()
