
import gurobipy as gp

# Create a new model
m = gp.Model("tea_production")

# Create variables
x1 = m.addVar(lb=0, name="x1") # oolong tea
x2 = m.addVar(lb=0, name="x2") # green tea

# Set objective function
m.setObjective(30*x1 + 20*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, "oolong_demand")
m.addConstr(x2 <= 80, "green_demand")
m.addConstr(x1 + x2 <= 150, "total_production")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Oolong tea bottles: {x1.x:.0f}")
    print(f"Green tea bottles: {x2.x:.0f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

