
from gurobipy import *

# Create a new model
m = Model("Tea_Shop_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="Oolong_Tea")
x2 = m.addVar(lb=0, name="Green_Tea")

# Set the objective function
m.setObjective(30*x1 + 20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, "Oolong_Demand")
m.addConstr(x2 <= 80, "Green_Demand")
m.addConstr(x1 + x2 <= 150, "Total_Supply")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Oolong Tea: {x1.x}")
    print(f"Green Tea: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
