
import gurobi

def solve_tea_shop_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="x1")  # bottles of oolong tea per day
    x2 = model.addVar(lb=0, name="x2")  # bottles of green tea per day

    # Define the objective function
    model.setObjective(30*x1 + 20*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(x1 <= 100, name="demand_oolong")
    model.addConstr(x2 <= 80, name="demand_green")
    model.addConstr(x1 + x2 <= 150, name="supply_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_tea_shop_problem()
