
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("concert_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="first_floor_seats") # Number of first-floor seats
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="second_floor_seats") # Number of second-floor seats

# Set objective function: Maximize profit
m.setObjective(100*x1 + 70*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 250, "total_seats") # Total seats constraint
m.addConstr(x1 >= 70, "min_first_floor") # Minimum first-floor seats
m.addConstr(x2 >= 2*x1, "second_floor_preference") # Second-floor preference constraint

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of first-floor seats: {x1.x}")
    print(f"Number of second-floor seats: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

