
import gurobi

def solve_concert_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="first_floor_seats")
    x2 = model.addVar(lb=0, name="second_floor_seats")

    # Objective function: maximize 100*x1 + 70*x2
    model.setObjective(100*x1 + 70*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 250, name="total_seats")
    model.addConstr(x1 >= 70, name="min_first_floor")
    model.addConstr(x2 >= 2*x1, name="second_floor_preference")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of first-floor seats: {x1.varValue}")
        print(f"Number of second-floor seats: {x2.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_concert_seating_problem()
