
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Bobs_Farm")

# Create variables
daisies = m.addVar(lb=0, name="daisies")  # Acres of daisies
peonies = m.addVar(lb=0, name="peonies")  # Acres of peonies


# Set objective function: Maximize profit
m.setObjective(55 * daisies + 80 * peonies, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * daisies + 35 * peonies <= 3000, "budget_constraint")  # Budget constraint
m.addConstr(daisies + peonies <= 100, "land_constraint")  # Land constraint


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal Solution:")
    print(f"  Daisies: {daisies.x:.2f} acres")
    print(f"  Peonies: {peonies.x:.2f} acres")
    print(f"  Maximum Profit: ${m.objVal:.2f}")

