
from gurobipy import *

# Create a new model
m = Model("Agricultural_Land_Optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="daisies_acres")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peonies_acres")

# Set the objective function
m.setObjective(55*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 35*x2 <= 3000, "budget_constraint")
m.addConstr(x1 + x2 <= 100, "land_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Daisies acres: {x1.x}")
    print(f"Peonies acres: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
