
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="daisies")
    x2 = model.addVar(lb=0, name="peonies")

    # Set the objective function
    model.setObjective(55 * x1 + 80 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 100, name="land_constraint")
    model.addConstr(20 * x1 + 35 * x2 <= 3000, name="budget_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of daisies: {x1.varValue}")
        print(f"Acres of peonies: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
