
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("perfume_cologne")

# Create variables
perfume = m.addVar(lb=0, vtype=GRB.INTEGER, name="perfume")
cologne = m.addVar(lb=0, vtype=GRB.INTEGER, name="cologne")


# Set objective function
m.setObjective(50 * perfume + 60 * cologne, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * perfume + 2.5 * cologne <= 700, "time_constraint")
m.addConstr(perfume >= 60, "perfume_min")
m.addConstr(cologne >= 40, "cologne_min")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of perfume bottles to fill: {perfume.x}")
    print(f"Number of cologne bottles to fill: {cologne.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

