
from gurobipy import *

# Create a new model
m = Model("Makeup_Company")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="perfume_bottles")
x2 = m.addVar(vtype=GRB.INTEGER, name="cologne_bottles")

# Set objective function
m.setObjective(50*x1 + 60*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 2.5*x2 <= 700, "time_constraint")
m.addConstr(x1 >= 60, "min_perfume_bottles")
m.addConstr(x2 >= 40, "min_cologne_bottles")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of perfume bottles: {x1.x}")
    print(f"Number of cologne bottles: {x2.x}")
    print(f"Maximum profit: ${50*x1.x + 60*x2.x:.2f}")
else:
    print("No optimal solution found")
