
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="perfume_bottles")
    x2 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="cologne_bottles")

    # Set the objective function
    model.setObjective(50 * x1 + 60 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 >= 60, name="perfume_min")
    model.addConstr(x2 >= 40, name="cologne_min")
    model.addConstr(2 * x1 + 2.5 * x2 <= 700, name="time_limit")

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of perfume bottles: {x1.varValue}")
        print(f"Number of cologne bottles: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_problem()
