
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("leather_goods")

# Create variables
wallets = m.addVar(lb=0, vtype=GRB.INTEGER, name="wallets")
purses = m.addVar(lb=0, vtype=GRB.INTEGER, name="purses")


# Set objective function
m.setObjective(40 * wallets + 85 * purses, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * wallets + 4 * purses <= 2000, "leather_constraint")
m.addConstr(purses >= 4 * wallets, "popularity_constraint")
m.addConstr(wallets >= 10, "min_wallets_constraint")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of wallets: {wallets.x}")
    print(f"Number of purses: {purses.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

