
import gurobi

def solve_leatherworker_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="wallets", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="purses", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 40*x1 + 85*x2
    model.setObjective(40*x1 + 85*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 4*x2 <= 2000, name="leather_constraint")
    model.addConstr(x2 >= 4*x1, name="popularity_constraint")
    model.addConstr(x1 >= 10, name="min_wallets_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: wallets = {x1.varValue}, purses = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_leatherworker_problem()
