
from gurobipy import Model, GRB

# Create a new model
model = Model("Seafood Packaging")

# Create variables
fish = model.addVar(vtype=GRB.CONTINUOUS, name="fish")  # Packages of fish meat
shrimp = model.addVar(vtype=GRB.CONTINUOUS, name="shrimp")  # Packages of shrimp meat

# Set objective function
model.setObjective(7 * fish + 3 * shrimp, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * fish + 1.5 * shrimp <= 1200, "Weight_Checking")  # Weight checking machine constraint
model.addConstr(15 * fish + 7 * shrimp <= 1200, "Packaging_Inspection")  # Packaging inspection machine constraint
model.addConstr(fish >= 0, "Fish_NonNegativity")  # Non-negativity constraint for fish
model.addConstr(shrimp >= 0, "Shrimp_NonNegativity")  # Non-negativity constraint for shrimp


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Packages of fish meat: {fish.x:.2f}")
    print(f"Packages of shrimp meat: {shrimp.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

