
from gurobipy import *

# Create a new model
m = Model("Seafood_Packaging")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="fish_meat_packages")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="shrimp_meat_packages")

# Set the objective function
m.setObjective(7*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 1.5*x2 <= 1200, "weight_checking_machine")
m.addConstr(15*x1 + 7*x2 <= 1200, "packaging_inspection_machine")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
