
import gurobipy as gp

# Create a new model
model = gp.Model("Seafood_Factory_Optimization")

# Define variables
x1 = model.addVar(name="fish_meat_packages", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="shrimp_meat_packages", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize 7*x1 + 3*x2
model.setObjective(7*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3*x1 + 1.5*x2 <= 1200, name="weight_checking_constraint")
model.addConstr(15*x1 + 7*x2 <= 1200, name="packaging_inspection_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Fish meat packages: {x1.varValue}")
    print(f"Shrimp meat packages: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or has no solution.")
