
import gurobipy as gp

# Create a new model
m = gp.Model("tin_production")

# Create variables
almond_tins = m.addVar(vtype=gp.GRB.CONTINUOUS, name="almond_tins")
cashew_tins = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cashew_tins")


# Set objective function
m.setObjective(10 * almond_tins + 15 * cashew_tins, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * almond_tins + 4 * cashew_tins <= 400, "filling_time")
m.addConstr(3 * almond_tins + 5 * cashew_tins <= 500, "labeling_time")
m.addConstr(almond_tins >= 0, "almond_non_negativity")
m.addConstr(cashew_tins >= 0, "cashew_non_negativity")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of almond tins: {almond_tins.x}")
    print(f"Number of cashew tins: {cashew_tins.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

