
from gurobipy import *

# Create a new model
m = Model("Almond_Cashew_Optimization")

# Define variables
x1 = m.addVar(name="almond_tins", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="cashew_tins", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(10*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 <= 400, name="filling_time")
m.addConstr(3*x1 + 5*x2 <= 500, name="labeling_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Almond tins: {x1.x}")
    print(f"Cashew tins: {x2.x}")
    print(f"Maximum profit: ${10*x1.x + 15*x2.x:.2f}")
else:
    print("No optimal solution found")
