
import gurobipy as gp

# Create a new model
model = gp.Model("Almond_Cashew_Optimization")

# Define the variables
x1 = model.addVar(name="almond_tins", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="cashew_tins", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(10*x1 + 15*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x1 + 4*x2 <= 400, name="filling_time_constraint")
model.addConstr(3*x1 + 5*x2 <= 500, name="labeling_time_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Almond tins = {x1.varValue}, Cashew tins = {x2.varValue}")
    print(f"Maximum profit: ${10*x1.varValue + 15*x2.varValue}")
else:
    print("The model is infeasible.")
