
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("jacket_production")

# Create variables
flight_jackets = m.addVar(vtype=GRB.CONTINUOUS, name="flight_jackets")
denim_jackets = m.addVar(vtype=GRB.CONTINUOUS, name="denim_jackets")

# Set objective function
m.setObjective(70 * flight_jackets + 100 * denim_jackets, GRB.MAXIMIZE)

# Add constraints
m.addConstr(flight_jackets <= 10, "flight_jacket_production_limit")
m.addConstr(denim_jackets <= 25, "denim_jacket_production_limit")
m.addConstr(flight_jackets + denim_jackets <= 30, "sewing_machine_limit")
m.addConstr(flight_jackets >= 0, "flight_jackets_non_negative")  # Ensure non-negative production
m.addConstr(denim_jackets >= 0, "denim_jackets_non_negative") # Ensure non-negative production


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Flight jackets to produce: {flight_jackets.x:.2f}")
    print(f"Denim jackets to produce: {denim_jackets.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

